'use strict';

function ResultsGroupsCtrl($scope, $window, GroupResults, $http, AppConfig, $rootScope){
    $scope.list = GroupResults.loadData();


    $scope.openReport = function(report){
        $window.open(appDev + '/report/' + report.product_code.code);
    }

    $scope.exportGroupReportN3 = function(report, groupId) {
        var message = {
            title: 'Generowanie pliku'
            ,msg: 'Proszę czekać'
            ,type: 'loading'
        }
        $rootScope.$broadcast('Message:addMsg', message);
        $http.post(AppConfig.urlGroupReportN3, {n3data: report, company: groupId})
            .success(function(data){
                $rootScope.$broadcast('Message:delMsg', message);
                if(data == 'OK') {$rootScope.getSessionFile();}
            })
            .error(function(data){
                $rootScope.$broadcast('Message:delMsg', message);
            })
        ;

    }

    $scope.reportFromSQL = function(report, groupId) {
        var message = {
            title: 'Generowanie pliku'
            ,msg: 'Proszę czekać'
            ,type: 'loading'
        }
        $rootScope.$broadcast('Message:addMsg', message);
        $http.post(AppConfig.urlGroupReportN3SQL, {n3data: report, company: groupId})
            .success(function(data){
                $rootScope.$broadcast('Message:delMsg', message);
                if(data == 'OK') {$rootScope.getSessionFile();}
            })
            .error(function(data){
                $rootScope.$broadcast('Message:delMsg', message);
            })
        ;
    }

    $scope.exportGroupEffectsN3 = function() {
        var message = {
            title: 'Generowanie pliku'
            ,msg: 'Proszę czekać'
            ,type: 'loading'
        }
        $rootScope.$broadcast('Message:addMsg', message);
        $http.post(AppConfig.urlGroupEffectN3, {})
            .success(function(data){
                $rootScope.$broadcast('Message:delMsg', message);
                if(data == 'OK') {$rootScope.getSessionFile();}
            })
            .error(function(data){
                $rootScope.$broadcast('Message:delMsg', message);
            })
        ;
    }

    $scope.areCompanyWithRoundOne = function() {
        var check = false;
        angular.forEach($scope.list, function(group) {
            if(group.company.length > 0)
            {
                angular.forEach(group.company[0].round_reports, function(report) {
                    check = true;
                });
            }
        });
        return check;
    }
}

ResultsGroupsCtrl.$inject = ['$scope', '$window', 'GroupResults', '$http', 'AppConfig', '$rootScope'];